Import-Module Microsoft.Graph.DeviceManagement

####################################################
<# region Authentication
To authenticate, you'll use the Microsoft Graph PowerShell SDK. If you haven't already installed the SDK, see this guide:
https://learn.microsoft.com/en-us/powershell/microsoftgraph/installation?view=graph-powershell-1.0

The PowerShell SDK supports two types of authentication: delegated access, and app-only access.

For details on using delegated access, see this guide here:
https://learn.microsoft.com/powershell/microsoftgraph/get-started?view=graph-powershell-1.0

For details on using app-only access for unattended scenarios, see Use app-only authentication with the Microsoft Graph PowerShell SDK:
https://learn.microsoft.com/powershell/microsoftgraph/app-only?view=graph-powershell-1.0&tabs=azure-portal

#>
#endregion

####################################################

$windows = @"

{
    "@odata.type":  "#microsoft.graph.windows10CustomConfiguration",
    "DisplayName":  "DoD Adobe Acrobat Reader DC Continuous STIG v2r1 Custom Profile",
    "omaSettings":  [
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must enable Enhanced Security in a Standalone Application",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_Security/Enable_Enhanced_security_standalone",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "ARDC-CN-000005"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must enable Enhanced Security in a Browser",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_Security/Enable_Enhanced_security_inbrowser",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "ARDC-CN-000010"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must Protected Mode",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Protected_Mode",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "ARDC-CN-000015"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must enable Protected View",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_Security/Protected_View",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e \u003cdata id=\"Protected_ViewDropID\" value=\"2\"/\u003e",
                            "displayName":  "ARDC-CN-000020"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must block websites",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_TrustManager/Access_to_websites",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e \u003cdata id=\"Access_to_websitesDropID\" value=\"1\"/\u003e",
                            "displayName":  "ARDC-CN-000025"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must block access to unknown websites",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_TrustManager/Access_to_unknown_websites",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e \u003cdata id=\"Access_to_unknown_websitesDropID\" value=\"3\"/\u003e",
                            "displayName":  "ARDC-CN-000030"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must prevent opening other files than PDF or FDF",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_TrustManager/Non_PDF_Attachments",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000035"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must block Flash content",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Enable_Flash",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000045"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable the ability to change the default handler",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_General/Disable_PDF_Handler",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "ARDC-CN-000050"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable the Adobe Send and Track plugin for Outlook",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Send_and_Track_plugin",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000055"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adober Reader DC must disable all service access to Document Cloud Services",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Document_cloud",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000060"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable Cloud Synchronization",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Cloud_Synchronization",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000065"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable the Adobe Repair installation 32-bit",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_Help/Repair_installation_32",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000070 32-bit"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must the Adobe repair installation 64-bit",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_Help/Repair_installation_64",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000070 64-bit"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable 3rd party web connectors",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Web_connectors",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000075"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable Acrobat Upsell",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Acrobat_Upsell",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000080"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable Adobe Send for Signature",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Send_for_Signature",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000085"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable access Webmail",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Webmail",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000090"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable Online SharePoint Access",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Cloud_features",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000100"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable the Adobe welcome screen",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/WelcomeScreen",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000115"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable Service upgrades",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Service_Upgrades",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000120"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable the ability to add Trusted Files and Folders",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_Security/Privilege_folder_location",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000315"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable the ability to elevate IE Trusts to Privileged Locations",
                            "omaUri":  "./Device/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_Security/Trusted_Host",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000320"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable periodical uploading of European certificates",
                            "omaUri":  "./User/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_TrustManager/European_certificates",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000330"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must disable periodical uploading of Adobe certificates",
                            "omaUri":  "./User/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences~Cat_TrustManager/Adobe_certificates",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cdisabled/\u003e",
                            "displayName":  "ARDC-CN-000335"
                        },
                        {
                            "@odata.type":  "#microsoft.graph.omaSettingString",
                            "description":  "Adobe Reader DC must enable FIPS mode",
                            "omaUri":  "./User/Vendor/MSFT/Policy/Config/Adobe Acrobat Reader DC Continuous~Policy~Cat_Adobe_DC_Continuous~Cat_Preferences/Enable_FIPS",
                            "secretReferenceValueId":  null,
                            "value":  "\u003cenabled/\u003e",
                            "displayName":  "ARDC-CN-000345"
                        }
                                        
                    ]

}

"@

####################################################

New-MgDeviceManagementDeviceConfiguration -BodyParameter $Windows